/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt.bin;

import de.superx.bin.SxConnection;
import de.superx.elt.QueryResultSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Doquery {
    private static Connection myDb;
    private static Statement st;
    private static DatabaseMetaData dbmd;
    private static boolean done;
    private static String delim;
    private static String header;
    private static String outFormat;
    private static String logfile;
    private static String tabelle;
    private static String dbpropfile;
    private static SxConnection myConnection;
    private static String db_driver;
    private static String mandantenID;
    private static String outfile;
    private static Logger logger;
    private static String usage;

    public static int go(String[] args) throws Exception {
        StringWriter sw;
        boolean printColname;
        if (args.length <= 0) {
            throw new IllegalArgumentException("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
        }
        logfile = args[0].trim();
        File f = new File(logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        String query = "";
        long numberOfRows = 0L;
        int returnCode = 0;
        if (args.length > 1) {
            dbpropfile = args[1].trim();
        } else {
            logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
            System.exit(1);
        }
        if (args.length <= 2) {
            logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
            System.exit(1);
        }
        query = args[2].trim();
        if (args.length > 3) {
            outFormat = args[3].trim();
        }
        if (args.length > 4) {
            delim = args[4].trim();
        }
        if (args.length > 5) {
            header = args[5].trim();
        }
        if (args.length > 6) {
            outfile = args[6].trim();
        }
        if (delim.equals("")) {
            delim = "^";
        }
        long jetzt = new Date().getTime();
        Doquery.getConnection(logger, dbpropfile);
        QueryResultSerializer myQueryResultSerializer = null;
        boolean bl = printColname = header.equalsIgnoreCase("true");
        if (!outfile.equals("")) {
            try {
                FileWriter fw = new FileWriter(outfile);
                if (outFormat.equalsIgnoreCase("xml")) {
                    fw.write("<?xml version=\"1.0\"  encoding=\"UTF-8\" ?>");
                }
                myQueryResultSerializer = new QueryResultSerializer("default", myConnection, query, fw);
            }
            catch (IOException e) {
                logger.severe("Fehler beim Erstellen der Datei " + outfile);
                returnCode = 1;
            }
        } else {
            sw = new StringWriter();
            if (outFormat.equalsIgnoreCase("xml")) {
                sw.write("<?xml version=\"1.0\"  encoding=\"UTF-8\" ?>");
            }
            myQueryResultSerializer = new QueryResultSerializer("default", myConnection, query, sw);
        }
        numberOfRows = myQueryResultSerializer.unloadQueryResults("DOQUERY", outFormat, delim, printColname);
        returnCode = myQueryResultSerializer.getReturnCode();
        if (outfile.equals("")) {
            sw = myQueryResultSerializer.getOutputString();
            System.out.println(sw.toString());
        }
        long erstrecht = new Date().getTime();
        System.out.println(numberOfRows + " rows unloaded  in " + (erstrecht - jetzt) / 1000L + " Sec.");
        System.out.println("returnCode= " + returnCode);
        myQueryResultSerializer = null;
        return returnCode;
    }

    public static void instructions() {
        System.out.println("SuperX 0.4b\n");
        System.out.println("\nDieses Java-Programm f\u00fchrt einen SQL-Ausdruck aus und gibt das Ergebnis aus.\n");
        System.out.println("Gebrauch:\n java doquery <Pfad zu logger-properties> <pfad zu db.properties> <sql-Ausdruck> <Ausgabeformat (txt | html | xml)>(optional) <delimiter> <mit Spalten\u00fcberschriften (true | false)>(optional) <Ausgabedatei>(optional)\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        int returnCode = 0;
        try {
            returnCode = Doquery.go(args);
        }
        catch (Exception ex) {
            System.err.println("Doquery Aufruf fehlgeschlagen.\n" + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println("Doquery Aufruf ausgef\u00fchrt.\n");
        System.exit(returnCode);
    }

    public static void getConnection(Logger logger, String propFile) throws SQLException {
        myConnection = new SxConnection();
        myConnection.setPropfile(propFile);
        logger.config("Starting Connection...");
        try {
            myDb = myConnection.getConnection();
            st = myDb.createStatement();
            dbmd = myDb.getMetaData();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Keine DB-Verbindung: " + e.toString());
            throw new SQLException("Keine DB-Verbindung: " + e.toString());
        }
        db_driver = Doquery.myConnection.m_DriverClass;
    }

    static {
        done = false;
        delim = "^";
        header = "false";
        outFormat = "txt";
        logfile = "../conf/logging.properties";
        tabelle = "";
        dbpropfile = "../conf/db.properties";
        myConnection = null;
        mandantenID = "default";
        outfile = "";
        logger = Logger.getLogger(Doquery.class.toString());
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES $sql (optional: )$outformat $DBDELIMITER $header $filename  \n---------------------------------------------------";
    }
}

