/*
 * Decompiled with CFR 0.152.
 */
package de.superx.sxrest;

import de.superx.common.SxUser;
import de.superx.elt.EtlActionJob;
import de.superx.elt.EtlUtils;
import de.superx.servlet.SuperXManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;

@Path(value="/launchupgrade")
public class LaunchUpgrade {
    @Context
    Request request;

    @GET
    @Path(value="/{param}")
    @Produces(value={"text/plain"})
    public String printXml(@PathParam(value="param") String componentName, @Context HttpServletRequest request) {
        String jobOutput = "";
        String jobLog = "";
        int returnCode = 0;
        SxUser user = (SxUser)request.getSession().getAttribute("user");
        String mandantenid = (String)request.getSession().getAttribute("MandantenID");
        if (mandantenid == null || mandantenid.equals("")) {
            mandantenid = "default";
        }
        if (user == null || !user.isAdmin()) {
            jobLog = jobLog + "Fehlende Rechte";
            returnCode = 1;
        } else {
            String job = componentName + "_upgrade";
            String params = componentName.toUpperCase() + "_PFAD=" + SuperXManager.getWEB_INFPfad() + EtlUtils.PATHSEP + "conf" + EtlUtils.PATHSEP + "edustore" + EtlUtils.PATHSEP + "db" + EtlUtils.PATHSEP + "module" + EtlUtils.PATHSEP + componentName;
            EtlActionJob myJob = new EtlActionJob(job);
            try {
                myJob.initJob(job, params);
            }
            catch (Exception e) {
                returnCode = 1;
                jobLog = jobLog + myJob.getActionLog().toString();
                jobLog = jobLog + e.toString();
                jobLog = jobLog + myJob.getLogoutput();
            }
            try {
                returnCode = myJob.execute("");
                jobOutput = jobOutput + myJob.getSw().toString();
                jobLog = jobLog + myJob.getActionLog().toString();
            }
            catch (Exception e) {
                returnCode = 1;
                jobLog = jobLog + myJob.getActionLog().toString();
                jobLog = jobLog + e.toString();
                jobLog = jobLog + myJob.getLogoutput();
            }
        }
        if (returnCode == 0) {
            return "Upgrade erfolgreich: " + EtlUtils.NEWLINE + jobLog;
        }
        return "Upgrade mit Fehler beendet: " + EtlUtils.NEWLINE + jobLog;
    }
}

