/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt.bin;

import de.superx.elt.TableUploader;
import de.superx.elt.util.GetOpts;
import java.util.Date;

public class UploadRecords {
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.UploadRecords \n-dbproperties:<Pfad zu db.properties> \n-table:<Tabellenname> \n-unl:<Dateipfad Quelldatei>(optional, default ist Tabellenname.unl) \n-delim:<delimiter>(optional, default ist ^) \n-header:<true|false>(optional, mit Feld\u00fcberschriften, default ist false)\n-mode:<stop|exclude-row>(optional, default is stop) #Bei Fehlerhaften Daten kann das Hochladen gestoppt werden, oder der Datensatz wird \u00fcbersprungen\n-inserts:<false|simple|batch>(optional, default is false) #Bei -inserts:simple und batch werden Die Rohdaten in Insert-sql-Statements \u00fcbersetzt (nur f\u00fcr Debugging-Zwecke, sehr langsam. Der Modus exclude-field ist dar\u00fcberhinaus nicht anwendbar)\n-encoding:<utf8,ISO-8859-1, default ist System.file.encoding>\n---------------------------------------------------";

    public static void main(String[] args) {
        try {
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-dbproperties,-table,-unl");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.err.println(usage);
                System.exit(1);
            }
            TableUploader myUploader = new TableUploader();
            if (GetOpts.isPresent("-dbproperties")) {
                myUploader.setDbpropfile(GetOpts.getValue("-dbproperties"));
            }
            if (GetOpts.isPresent("-informat")) {
                myUploader.setInFormat(GetOpts.getValue("-informat"));
            }
            if (GetOpts.isPresent("-table")) {
                myUploader.setTargetTable(GetOpts.getValue("-table"));
            }
            if (GetOpts.isPresent("-unl")) {
                myUploader.setSrcFile(GetOpts.getValue("-unl"));
            } else {
                myUploader.setSrcFile(myUploader.getTargetTable() + ".unl");
            }
            if (GetOpts.isPresent("-header")) {
                myUploader.setHeader(GetOpts.getValue("-header").equalsIgnoreCase("true"));
            }
            if (GetOpts.isPresent("-delim")) {
                myUploader.setDelim(GetOpts.getValue("-delim"));
            }
            if (GetOpts.isPresent("-encoding")) {
                String encodingParam = GetOpts.getValue("-encoding");
                if (encodingParam != null && !encodingParam.equals("")) {
                    myUploader.setEncoding(encodingParam);
                }
            } else {
                myUploader.setEncoding(System.getProperty("file.encoding"));
            }
            if (GetOpts.isPresent("-mode")) {
                myUploader.setMode(GetOpts.getValue("-mode").toLowerCase());
            }
            if (GetOpts.isPresent("-inserts")) {
                myUploader.setInserts(GetOpts.getValue("-inserts"));
            }
            long jetzt = new Date().getTime();
            long numberOfRows = 0L;
            myUploader.setUploadConnection(myUploader.getConnection(null, myUploader.getDbpropfile()));
            numberOfRows = myUploader.uploadFile();
            long erstrecht = new Date().getTime();
            System.out.println(numberOfRows + " lines loaded");
            System.out.println("File " + myUploader.getSrcFile() + " uploaded, returnCode=" + myUploader.getReturnCode());
            Object var2_3 = null;
        }
        catch (Exception ex) {
            System.err.println("Upload fehlgeschlagen: " + ex);
            System.exit(1);
        }
    }
}

