/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt;

import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxSqlHelper;
import de.superx.elt.EtlAction;
import de.superx.elt.EtlStep;
import de.superx.elt.EtlUtils;
import de.superx.util.SqlStringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class EtlActionJob
extends EtlAction {
    private String mandantenID;
    private String jobTid;
    private String jobUniquename;
    private String jobLogfile;
    private String jobCaption;
    private Properties runTimeParams;
    private StringWriter sw = new StringWriter();

    public EtlActionJob(String uniquename, String logfile, String propfile) {
        super(uniquename, logfile, propfile);
    }

    public EtlActionJob(String uniquename) {
        super(uniquename);
    }

    public StringWriter getSw() {
        return this.sw;
    }

    public void setSw(StringWriter sw) {
        this.sw = sw;
    }

    public void setRunTimeParams(String runTimeParamsArg) throws IOException {
        if (runTimeParamsArg != null) {
            this.runTimeParams = de.superx.etl.EtlUtils.convertStringToProperty((String)runTimeParamsArg);
        }
    }

    public void initJob(String job, String runtimeParamsArg) throws Exception {
        long jetzt = new Date().getTime();
        de.superx.etl.EtlUtils.initJobEnvironment();
        String paramName = null;
        String paramDefault = "";
        String paramProperties = "";
        if (runtimeParamsArg == null) {
            runtimeParamsArg = "";
        }
        runtimeParamsArg = "SUPERX_DIR=" + de.superx.etl.EtlUtils.SUPERX_DIR + de.superx.etl.EtlUtils.NEWLINE + runtimeParamsArg;
        this.setStarttime(jetzt);
        Connection myConnection = this.getDbconnection();
        if (myConnection == null) {
            myConnection = this.getConnection(myConnection);
        }
        this.setDbconnection(myConnection);
        if (!SqlStringUtils.checkValidKeyEntry((String)job)) {
            throw new SQLException("Invalid job " + job);
        }
        String sql = "select J.tid,J.uniquename,J.caption,J.logfile, P.uniquename as param_name,P.name as param_caption, P.param_default from etl_job J left outer join etl_job_param P on (J.tid=P.etl_job_id) where J.uniquename='" + job + "';";
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        sh.execute(sql, myConnection, el);
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei Job DETAILS:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        SxResultSet result = el.getResultSet();
        int rownr = 0;
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ++rownr;
            SxResultRow row = (SxResultRow)it.next();
            this.jobTid = row.get(0).toString().trim();
            this.jobUniquename = row.get(1).toString().trim();
            this.jobCaption = row.get(2).toString().trim();
            this.jobLogfile = row.get(3).toString().trim();
            if (row.get(4) != null) {
                paramName = row.get(4).toString().trim();
            }
            if (row.get(5) != null) {
                String string = row.get(5).toString().trim();
            }
            if (row.get(4) != null) {
                paramDefault = row.get(6).toString().trim();
            }
            if (paramName == null) continue;
            paramProperties = paramProperties + paramName + "=" + paramDefault + de.superx.etl.EtlUtils.NEWLINE;
        }
        if (rownr == 0) {
            throw new Exception("Job " + job + " unbekannt");
        }
        super.addActionLog("Job gefunden: " + this.jobCaption + de.superx.etl.EtlUtils.NEWLINE);
        if (!paramProperties.equals("")) {
            this.setParams(de.superx.etl.EtlUtils.convertStringToProperty((String)paramProperties));
        }
        if (runtimeParamsArg != null) {
            this.setRunTimeParams(runtimeParamsArg);
            super.addActionLog("Runtime Params: " + runtimeParamsArg);
        }
        if (this.runTimeParams != null) {
            this.setParams(EtlUtils.mergeParamProperties(this.getParams(), this.runTimeParams));
        }
        super.addActionLog("Job " + this.jobCaption + " initialized");
    }

    public int execute(String outfile) throws SQLException, Exception {
        int jobReturnCode = 0;
        String sql = "select S.tid,S.uniquename,S.caption,S.systeminfo_id,R.sortnr,R.force_continue::integer as force_continue,R.parent_step_id,S.logfile,T.uniquename,T.caption,T.handler";
        sql = sql + " FROM etl_step S, etl_step_type T, etl_step_relation R where T.tid=S.step_type_id and R.step_id=S.tid and  R.job_id=" + this.jobTid + " order by R.sortnr,R.tid;";
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        try {
            sh.execute(sql, this.getConnection(null), el);
        }
        catch (Exception e1) {
            super.addActionLog("Fehler beim SQL: " + sql + de.superx.etl.EtlUtils.NEWLINE + el.getError_String().trim());
            return 1;
        }
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei Steps DETAILS:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        SxResultSet result = el.getResultSet();
        int rownr = 0;
        super.addActionLog("Steps found: " + result.size());
        this.sw.write("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\" ?><etlAction name=\"" + this.jobUniquename + "\">\n");
        Iterator it = result.iterator();
        while (it.hasNext()) {
            int stepReturnCode = 0;
            ++rownr;
            SxResultRow row = (SxResultRow)it.next();
            Integer stepTid = (Integer)row.get(0);
            String stepUniquename = row.get(1).toString().trim();
            String stepCaption = row.get(2).toString().trim();
            Integer stepSortnr = (Integer)row.get(4);
            Integer stepForceContinue = (Integer)row.get(5);
            Integer stepParentStepId = (Integer)row.get(6);
            String stepLogfile = row.get(7).toString().trim();
            String stepTypeUniquename = row.get(8).toString().trim();
            String stepTypeCaption = row.get(9).toString().trim();
            String stepTypeHandler = row.get(10).toString().trim();
            EtlStep myStep = new EtlStep(stepUniquename, this.jobLogfile, this.propfile);
            myStep.setOutputStringWriter(this.sw);
            myStep.initStep(this.jobUniquename, this.getParams(), stepTid, stepUniquename, stepLogfile, stepCaption, stepSortnr, stepForceContinue, stepParentStepId, stepTypeUniquename, stepTypeCaption, stepTypeHandler);
            stepReturnCode = myStep.execute();
            super.addActionLog(myStep.getActionLog().toString());
            this.sw = myStep.getOutputStringWriter();
            if (stepReturnCode == 0) continue;
            if (stepForceContinue != 0) break;
            jobReturnCode = 1;
            break;
        }
        if (rownr == 0) {
            throw new Exception("Steps unbekannt");
        }
        this.sw.write("\n</etlAction>\n");
        if (outfile == null || outfile.equals("")) {
            System.out.println(this.sw.toString());
            System.out.println(super.getActionLog());
        } else {
            if (jobReturnCode == 1) {
                System.err.println(super.getActionLog());
                throw new Exception("Fehler bei Jobausf\u00fchrung");
            }
            System.out.println("Jobausf\u00fchrung Erfolg");
            try {
                EtlUtils.saveFileContentsWithEncoding(outfile, this.sw.toString(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                jobReturnCode = 1;
            }
        }
        long jetzt = new Date().getTime();
        this.setEndtime(jetzt);
        return jobReturnCode;
    }
}

