/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt;

import de.memtext.util.DateUtils;
import de.superx.bin.SxConnection;
import de.superx.elt.EtlUtils;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;

public class EtlAction {
    protected Properties params;
    private boolean contOnError;
    private String targetTable;
    private String logoutput;
    protected StringWriter actionOutput = new StringWriter();
    protected StringWriter actionLog = new StringWriter();
    private String loglevel = "INFO";
    private long starttime = new Date().getTime();
    protected long endtime;
    private int returnCode;
    private Connection dbconnection;
    private Properties env;
    private String uniquename;
    protected String logfile;
    protected String propfile;
    private String encoding = "UTF-8";
    protected DataSource dataSource;

    public EtlAction(String uniquename, String logfile, String propfile) {
        this.uniquename = uniquename;
        this.logfile = logfile;
        this.propfile = propfile;
        this.addActionLog("Action initialized" + de.superx.etl.EtlUtils.NEWLINE);
    }

    public EtlAction(String uniquename) {
        this.uniquename = uniquename;
        this.addActionLog("Action initialized" + de.superx.etl.EtlUtils.NEWLINE);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getDbconnection() {
        return this.dbconnection;
    }

    public void setDbconnection(Connection dbconnection) {
        this.dbconnection = dbconnection;
    }

    public String getUniquename() {
        return this.uniquename;
    }

    public void setUniquename(String uniquename) {
        this.uniquename = uniquename;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public Properties getEnv() {
        return this.env;
    }

    public void setEnv(Properties env) {
        this.env = env;
    }

    public Properties getParams() {
        return this.params;
    }

    public void setParams(Properties params) {
        this.params = params;
    }

    public boolean isContOnError() {
        return this.contOnError;
    }

    public void setContOnError(boolean contOnError) {
        this.contOnError = contOnError;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getLogoutput() {
        return this.logoutput;
    }

    protected void setLogoutput(String log) {
        this.logoutput = log;
    }

    protected void appendLog(String log) {
        this.logoutput = this.logoutput + log;
    }

    public String getLoglevel() {
        return this.loglevel;
    }

    public void setLoglevel(String loglevel) {
        this.loglevel = loglevel;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(long starttime) {
        this.starttime = starttime;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(long endtime) {
        this.endtime = endtime;
    }

    public long getDuration() {
        return (this.endtime - this.starttime) / 1000L;
    }

    public String getPropfile() {
        return this.propfile;
    }

    public void setPropfile(String propfile) {
        this.propfile = propfile;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public StringWriter getActionOutput() {
        return this.actionOutput;
    }

    public void setActionOutput(StringWriter actionOutput) {
        this.actionOutput = actionOutput;
    }

    public StringWriter getActionLog() {
        return this.actionLog;
    }

    public void setActionLog(StringWriter actionLog) {
        this.actionLog = actionLog;
    }

    public void addActionLog(String actionLog) {
        String log = DateUtils.getTodayString() + " " + DateUtils.getNowString();
        this.actionLog.append(log + "- " + actionLog + de.superx.etl.EtlUtils.NEWLINE);
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int execute() throws SQLException, Exception {
        int returncode = 0;
        this.endtime = new Date().getTime();
        return returncode;
    }

    public Connection getConnection(Connection myConnection) throws Exception {
        String myDefaultPropFile = EtlUtils.WEBINFDIR + EtlUtils.PATHSEP + "db.properties";
        if (myConnection == null) {
            if (this.propfile == null) {
                this.propfile = myDefaultPropFile;
            }
            SxConnection mySxConnection = null;
            mySxConnection = new SxConnection();
            mySxConnection.setPropfile(this.propfile);
            myConnection = mySxConnection.getConnection();
        }
        return myConnection;
    }
}

