/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt.bin;

import de.memtext.util.StringUtils;
import de.superx.elt.EtlActionJob;
import de.superx.elt.EtlUtils;
import de.superx.elt.util.GetOpts;

public class EtlJobExecutor {
    public static void main(String[] args) {
        String usage = "usage: java de.superx.elt.bin.EtlJobExecutor -dbproperties:$DB_PROPERTIES -job:abc -params:TID=16000 (optional) -outfile:Ausgabedatei (optional)";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-dbproperties,-job");
        if (isdrin != null) {
            System.err.println(usage);
            System.exit(1);
        }
        int returnCode = 0;
        String dbpropfile = GetOpts.getValue("-dbproperties");
        String job = GetOpts.getValue("-job");
        String params = null;
        if (GetOpts.isPresent("-params")) {
            params = GetOpts.getValue("-params");
        }
        if (params != null) {
            params = StringUtils.replace((String)params, (String)",", (String)EtlUtils.NEWLINE);
        }
        String outfile = null;
        if (GetOpts.isPresent("-outfile")) {
            outfile = GetOpts.getValue("-outfile");
        }
        EtlActionJob myJob = new EtlActionJob(job, "", dbpropfile);
        try {
            myJob.initJob(job, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(myJob.getLogoutput());
            System.exit(1);
        }
        System.out.println("Job " + job + " initialized");
        try {
            returnCode = myJob.execute(outfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(myJob.getLogoutput());
            System.exit(1);
        }
        System.out.println("Job " + job + " executed in " + myJob.getDuration() + " Sec.");
        System.exit(returnCode);
    }
}

