/*
 * Decompiled with CFR 0.152.
 */
package de.superx.elt;

import de.memtext.util.DateUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxSqlHelper;
import de.superx.common.TemplateProcessor;
import de.superx.util.SqlStringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;

public class EtlFmParser
extends TemplateProcessor {
    private String dbprop;
    private String infile;
    private String outfile;
    private Properties props;
    private Statement stm;
    private String isSimpleParser;
    private static String sqlDialect;

    EtlFmParser(String mandantenID, Connection con) {
        super(mandantenID, con);
    }

    private void initConAndParser() throws IOException, SQLException, ClassNotFoundException {
        this.stm = this.con.createStatement();
        if (SqlStringUtils.tableExists((Connection)this.con, (String)"fm_templates", (String)"default")) {
            this.setTemplates(this.readFromDb("select trim(both from id),content from fm_templates"));
            EtlFmParser.repositoryToMap((SxResultSet)this.readFromDb("select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1"), (HashMap)this.repositoryMap);
        }
        if (SqlStringUtils.tableExists((Connection)this.con, (String)"konstanten", (String)"default")) {
            SxResultSet rs = this.readFromDb("select trim(both from beschreibung),apnr from konstanten");
            for (SxResultRow row : rs) {
                String beschreibung = (String)row.get(0);
                this.repositoryMap.put("K_" + beschreibung.trim(), row.get(1));
            }
        }
    }

    protected SxResultSet readFromDb(String sql) throws SQLException {
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        sh.execute(sql, this.con, el);
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        return el.getResultSet();
    }

    public String simpleParser(String input) throws FileNotFoundException, IOException, Exception {
        String output = "";
        sqlDialect = "Postgres";
        this.initConAndParser();
        HashMap map = new HashMap();
        try {
            output = "--automatically created by SuperX/Freemarker for " + sqlDialect + " (" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + ")\n" + this.process("FM-Parsing ", input, map, sqlDialect);
        }
        catch (Exception e) {
            System.err.println("Fehler beim FM-Parsen ");
            e.printStackTrace();
            System.exit(1);
        }
        return output;
    }
}

